/**
 * ContextBridge - Shared Constants
 */

const CB_MSG_TYPES = {
  GET_CONTEXT: 'GET_CONTEXT',
  CONTEXT_RESPONSE: 'CONTEXT_RESPONSE',
  SUGGEST_ENTRY: 'SUGGEST_ENTRY',
  CHECK_ENABLED: 'CHECK_ENABLED',
  ENABLED_RESPONSE: 'ENABLED_RESPONSE',
  ADD_ENTRY: 'ADD_ENTRY',
  UPDATE_ENTRY: 'UPDATE_ENTRY',
  DELETE_ENTRY: 'DELETE_ENTRY',
  GET_SUGGESTIONS: 'GET_SUGGESTIONS',
  APPROVE_SUGGESTION: 'APPROVE_SUGGESTION',
  DISMISS_SUGGESTION: 'DISMISS_SUGGESTION',
  GET_SETTINGS: 'GET_SETTINGS',
  SAVE_SETTINGS: 'SAVE_SETTINGS',
  GET_STATS: 'GET_STATS',
  RECORD_INJECTION: 'RECORD_INJECTION',
  EXPORT_DATA: 'EXPORT_DATA',
  IMPORT_DATA: 'IMPORT_DATA',
  CLEAR_ALL: 'CLEAR_ALL',
  GET_ALL_ENTRIES: 'GET_ALL_ENTRIES',
  FORMAT_CONTEXT: 'FORMAT_CONTEXT'
};

const CB_CATEGORIES = {
  RULES: 'rules',
  PREFERENCES: 'preferences',
  PROJECTS: 'projects',
  TASKS: 'tasks',
  DECISIONS: 'decisions',
  PEOPLE: 'people'
};

// Ordered by injection priority (rules first, people last)
const CB_CATEGORY_ORDER = ['rules', 'preferences', 'projects', 'tasks', 'decisions', 'people'];

const CB_CATEGORY_NAMES = {
  rules: 'Rules',
  preferences: 'Preferences',
  projects: 'Projects',
  tasks: 'Tasks',
  decisions: 'Decisions',
  people: 'People'
};

const CB_PLATFORMS = {
  CHATGPT: 'chatgpt',
  CLAUDE: 'claude',
  GEMINI: 'gemini',
  COPILOT: 'copilot',
  CHARACTER_AI: 'character_ai',
  DEEPSEEK: 'deepseek',
  GROK: 'grok',
  PI: 'pi',
  POE: 'poe',
  PERPLEXITY: 'perplexity',
  HUGGINGCHAT: 'huggingchat',
  LECHAT: 'lechat'
};

const CB_PLATFORM_NAMES = {
  chatgpt: 'ChatGPT',
  claude: 'Claude',
  gemini: 'Gemini',
  copilot: 'Copilot',
  character_ai: 'Character.AI',
  deepseek: 'DeepSeek',
  grok: 'Grok',
  pi: 'Pi',
  poe: 'Poe',
  perplexity: 'Perplexity',
  huggingchat: 'HuggingChat',
  lechat: 'Le Chat'
};

const CB_DEFAULT_SETTINGS = {
  autoInject: true,
  autoSuggest: true,
  maxContextLength: 2000,
  platformsEnabled: {
    chatgpt: true,
    claude: true,
    gemini: true,
    copilot: true,
    character_ai: true,
    deepseek: true,
    grok: true,
    pi: true,
    poe: true,
    perplexity: true,
    huggingchat: true,
    lechat: true
  }
};

const CB_DEFAULT_STATS = {
  totalInjections: 0,
  lastInjection: null
};

const CB_SUGGESTIONS_CAP = 50;

const CB_TIMING = {
  OBSERVER_THROTTLE_MS: 500,
  URL_POLL_INTERVAL_MS: 1000,
  SCAN_INTERVAL_MS: 3000
};

if (typeof window !== 'undefined') {
  window.ContextBridge = window.ContextBridge || {};
  Object.assign(window.ContextBridge, {
    CB_MSG_TYPES, CB_CATEGORIES, CB_CATEGORY_ORDER, CB_CATEGORY_NAMES,
    CB_PLATFORMS, CB_PLATFORM_NAMES, CB_DEFAULT_SETTINGS, CB_DEFAULT_STATS,
    CB_SUGGESTIONS_CAP, CB_TIMING
  });
}
