/**
 * ContextBridge - Perplexity Extractor
 * perplexity.ai
 * User queries in span.select-text, AI answers in div.prose.
 */

(function () {
  const { BaseExtractor, SelectorEngine } = window.ContextBridge;

  class PerplexityExtractor extends BaseExtractor {
    constructor() {
      super('perplexity');
    }

    getPlatformConfig() {
      return {
        inputSelectors: [
          'textarea[placeholder]',
          'textarea'
        ],
        sendSelectors: [
          'button[aria-label="Submit"]',
          'button[aria-label="Send"]',
          'button[type="submit"]'
        ],
        inputType: 'textarea',
        messageContainer: [
          '[role="main"]',
          'main',
          '.max-w-threadContentWidth'
        ],
        userMessageSelectors: [
          'span.select-text'
        ],
        newConversationPattern: /^\/($|home)/,
        periodicScan: false
      };
    }

    extractUserTexts(node) {
      const texts = [];

      const tagName = (node.tagName || '').toLowerCase();
      const cn = typeof node.className === 'string' ? node.className : '';

      if (tagName === 'span' && cn.includes('select-text')) {
        const text = (node.textContent || '').trim();
        if (text.length >= 10) texts.push(text);
        return texts;
      }

      const userEls = node.querySelectorAll?.('span.select-text') || [];
      for (const el of userEls) {
        const text = (el.textContent || '').trim();
        if (text.length >= 10) texts.push(text);
      }

      return texts;
    }
  }

  const extractor = new PerplexityExtractor();
  extractor.init();
})();
