/**
 * ContextBridge - Google Gemini Extractor
 * gemini.google.com
 * Uses custom HTML elements: <user-query>, <model-response>
 */

(function () {
  const { BaseExtractor, SelectorEngine } = window.ContextBridge;

  class GeminiExtractor extends BaseExtractor {
    constructor() {
      super('gemini');
    }

    getPlatformConfig() {
      return {
        inputSelectors: [
          'rich-textarea',
          'rich-textarea div[contenteditable="true"]',
          'div[contenteditable="true"]',
          'textarea'
        ],
        sendSelectors: [
          'button[aria-label="Send message"]',
          'button[aria-label="Send"]',
          'button.send-button',
          'button[data-test-id="send-button"]'
        ],
        inputType: 'custom',
        messageContainer: [
          'chat-window',
          '[class*="conversation-container"]',
          '[role="main"]',
          'main'
        ],
        userMessageSelectors: [
          'user-query'
        ],
        newConversationPattern: /^\/($|app\/?$|app\/new)/,
        periodicScan: false
      };
    }

    extractUserTexts(node) {
      const texts = [];
      const tagName = (node.tagName || '').toLowerCase();

      if (tagName === 'user-query') {
        let text = (node.textContent || '').trim();
        text = text.replace(/^You said\s*/i, '');
        if (text.length >= 10) texts.push(text);
        return texts;
      }

      const userEls = node.querySelectorAll?.('user-query') || [];
      for (const el of userEls) {
        let text = (el.textContent || '').trim();
        text = text.replace(/^You said\s*/i, '');
        if (text.length >= 10) texts.push(text);
      }

      return texts;
    }
  }

  const extractor = new GeminiExtractor();
  extractor.init();
})();
