/**
 * ContextBridge - Microsoft Copilot Extractor
 * copilot.microsoft.com
 */

(function () {
  const { BaseExtractor, SelectorEngine } = window.ContextBridge;

  class CopilotExtractor extends BaseExtractor {
    constructor() {
      super('copilot');
    }

    getPlatformConfig() {
      return {
        inputSelectors: [
          'textarea#searchbox',
          'textarea[placeholder]',
          '[contenteditable="true"]',
          'textarea'
        ],
        sendSelectors: [
          'button[aria-label="Submit"]',
          'button[aria-label="Send"]',
          'button[type="submit"]'
        ],
        inputType: 'auto',
        messageContainer: [
          '[class*="conversation"]',
          '[role="main"]',
          'main'
        ],
        userMessageSelectors: [
          '[data-content="user-message"]'
        ],
        newConversationPattern: /^\/($|chat\/?$)/,
        periodicScan: false
      };
    }

    extractUserTexts(node) {
      const texts = [];

      if (node.getAttribute?.('data-content') === 'user-message') {
        const text = (node.textContent || '').trim();
        if (text.length >= 10) texts.push(text);
        return texts;
      }

      const userEls = node.querySelectorAll?.('[data-content="user-message"]') || [];
      for (const el of userEls) {
        const text = (el.textContent || '').trim();
        if (text.length >= 10) texts.push(text);
      }

      return texts;
    }
  }

  const extractor = new CopilotExtractor();
  extractor.init();
})();
