/**
 * ContextBridge - Content Bridge
 * IPC layer between content scripts and the service worker.
 */

(function () {
  window.ContextBridge = window.ContextBridge || {};

  const ContentBridge = {
    async send(type, payload = {}) {
      try {
        return await chrome.runtime.sendMessage({ type, payload });
      } catch (err) {
        console.warn('[ContextBridge] Message send failed:', err.message);
        return { success: false, error: err.message };
      }
    },

    async checkEnabled(platform) {
      return await this.send('CHECK_ENABLED', { platform });
    },

    async getContext() {
      return await this.send('GET_CONTEXT');
    },

    async suggestEntry(text, category, sourcePlatform) {
      return await this.send('SUGGEST_ENTRY', { text, category, sourcePlatform });
    },

    async recordInjection(platform) {
      return await this.send('RECORD_INJECTION', { platform });
    }
  };

  window.ContextBridge.ContentBridge = ContentBridge;
})();
