/**
 * ContextBridge - Browser Compatibility Layer
 * Normalizes chrome.* vs browser.* API namespaces
 */

const browserAPI = (typeof browser !== 'undefined' && browser.runtime) ? browser : chrome;

if (typeof window !== 'undefined') {
  window.ContextBridge = window.ContextBridge || {};
  window.ContextBridge.browserAPI = browserAPI;
}
