/**
 * ContextBridge - Pi Extractor
 * pi.ai
 * User messages identified by Tailwind alignment classes (ml-auto bg-neutral-200).
 */

(function () {
  const { BaseExtractor, SelectorEngine } = window.ContextBridge;

  class PiExtractor extends BaseExtractor {
    constructor() {
      super('pi');
    }

    getPlatformConfig() {
      return {
        inputSelectors: [
          'textarea',
          'textarea[placeholder]'
        ],
        sendSelectors: [
          'button[type="submit"]',
          'button[aria-label="Send"]',
          'button[aria-label="Send message"]'
        ],
        inputType: 'textarea',
        messageContainer: ['body'],
        useBodyAsContainer: true,
        userMessageSelectors: [
          '.ml-auto.bg-neutral-200',
          'div[class*="ml-auto"][class*="bg-neutral"]'
        ],
        newConversationPattern: /^\/($|chat\/?$|discover)/,
        periodicScan: true
      };
    }

    extractUserTexts(node) {
      const texts = [];

      if (this._isUserMessage(node)) {
        const text = (node.textContent || '').trim();
        if (text.length >= 10) texts.push(text);
        return texts;
      }

      const selectors = ['.ml-auto.bg-neutral-200', 'div[class*="ml-auto"][class*="bg-neutral"]'];
      for (const selector of selectors) {
        const els = node.querySelectorAll?.(selector) || [];
        for (const el of els) {
          const text = (el.textContent || '').trim();
          if (text.length >= 10) texts.push(text);
        }
        if (texts.length > 0) break;
      }

      return texts;
    }

    _isUserMessage(node) {
      const cn = typeof node.className === 'string' ? node.className : '';
      return cn.includes('ml-auto') && cn.includes('bg-neutral');
    }
  }

  const extractor = new PiExtractor();
  extractor.init();
})();
