/**
 * ContextBridge - HuggingChat Extractor
 * huggingface.co/chat
 * User messages are p tags with disabled class.
 */

(function () {
  const { BaseExtractor, SelectorEngine } = window.ContextBridge;

  class HuggingChatExtractor extends BaseExtractor {
    constructor() {
      super('huggingchat');
    }

    getPlatformConfig() {
      return {
        inputSelectors: [
          'textarea[placeholder]',
          'textarea'
        ],
        sendSelectors: [
          'button[type="submit"]',
          'button[aria-label="Send"]'
        ],
        inputType: 'textarea',
        messageContainer: ['body'],
        useBodyAsContainer: true,
        userMessageSelectors: [
          'p.disabled'
        ],
        newConversationPattern: /^\/chat\/?$/,
        periodicScan: true
      };
    }

    extractUserTexts(node) {
      const texts = [];

      const tagName = (node.tagName || '').toLowerCase();
      const cn = typeof node.className === 'string' ? node.className : '';

      if (tagName === 'p' && cn.includes('disabled')) {
        const text = (node.textContent || '').trim();
        if (text.length >= 10) texts.push(text);
        return texts;
      }

      const userEls = node.querySelectorAll?.('p.disabled') || [];
      for (const el of userEls) {
        const text = (el.textContent || '').trim();
        if (text.length >= 10) texts.push(text);
      }

      return texts;
    }
  }

  const extractor = new HuggingChatExtractor();
  extractor.init();
})();
