/**
 * ContextBridge - ChatGPT Extractor
 * chat.openai.com / chatgpt.com
 */

(function () {
  const { BaseExtractor, SelectorEngine } = window.ContextBridge;

  class ChatGPTExtractor extends BaseExtractor {
    constructor() {
      super('chatgpt');
    }

    getPlatformConfig() {
      return {
        inputSelectors: [
          '#prompt-textarea',
          'div[contenteditable="true"][data-placeholder]',
          'div.ProseMirror[contenteditable="true"]',
          'div[contenteditable="true"]'
        ],
        sendSelectors: [
          'button[data-testid="send-button"]',
          'button[aria-label="Send prompt"]',
          'button[aria-label="Send"]',
          'form button[type="submit"]'
        ],
        inputType: 'contenteditable',
        messageContainer: [
          'main div.flex-1.overflow-hidden',
          'main div[class*="react-scroll-to-bottom"]',
          'main div[role="presentation"]',
          'main'
        ],
        userMessageSelectors: [
          'div[data-message-author-role="user"]'
        ],
        newConversationPattern: /^\/($|chat\/?$|\?)/,
        periodicScan: false
      };
    }

    extractUserTexts(node) {
      const texts = [];

      // Check if node IS a user message
      if (node.getAttribute?.('data-message-author-role') === 'user') {
        const text = (node.textContent || '').trim();
        if (text.length >= 10) texts.push(text);
        return texts;
      }

      // Check if node CONTAINS user messages
      const userDivs = node.querySelectorAll?.('div[data-message-author-role="user"]') || [];
      for (const div of userDivs) {
        const text = (div.textContent || '').trim();
        if (text.length >= 10) texts.push(text);
      }

      return texts;
    }
  }

  const extractor = new ChatGPTExtractor();
  extractor.init();
})();
